<?php # Script 14.4 - tt_image.php

/* 	This page creates a simple image.
 *	The image will contain text of one color
 *	on a background of another color.
 *	The image makes use of a TrueType font.
 */
 
// Include the allocate_color() function:
require_once('allocate_color.php');

// Define the image information:
$text = 'Sam Atticus';
$font_size = 30; // Number in pixels
$text_color = 'white';
$bg_color = 'blue';
$font_file = 'arial.ttf'; // Full path to actual font file on server.

// Determine how much space the text will take:
$type_space = imagettfbbox ($font_size, 0, $font_file, $text);

// Determine the image width and height:
$image_width = abs($type_space[4] - $type_space[0]) + 10;
$image_height = abs($type_space[5] - $type_space[1]) + 10;

// Create the image:
$image = imagecreatetruecolor ($image_width, $image_height);

// Allocate the background color and fill the image:
$bg_color = allocate_color ($image, $bg_color);
imagefill ($image, 0, 0, $bg_color);

// Allocate the text color:
$text_color = allocate_color ($image, $text_color);

// Determine the initial x- and y- values:
$x = 5;
$y = $image_height - 5;

// Add the text to the image:
imagettftext ($image, $font_size, 0, $x, $y, $text_color, $font_file, $text);

// Make and send the image:
header ('Content-type: image/png');
imagepng ($image);

// Destroy the image:
imagedestroy ($image);
	
?>
