<?php # Script 14.5 - tt_image_save.php

/* 	This page creates a simple image.
 * 	The image will contain text of one color
 * 	on a background of another color.
 * 	The image makes use of a TrueType font.
 * 	The image will be saved on the server.
 */

// Include the allocate_color() function:
require_once('allocate_color.php');

// Define the image information:
$text = 'Elizabeth & Arthur';
$font_size = 50; // Number in pixels
$text_color = 'gray';
$bg_color = 'yellow';
$font_file = 'arial.ttf'; // Full path to actual font file on server.
$image_width = 300;
$file_name = 'my.png'; // Full path.

// Set the TrueType font size:
$type_space = imagettfbbox ($font_size, 0, $font_file, $text);

// Make the font size smaller if it's currently too large:
while ( (abs($type_space[4] - $type_space[0]) + 10) >= $image_width ) {
	
	$font_size -= 2; // 2 pixels smaller
	$type_space = imagettfbbox ($font_size, 0, $font_file, $text);
	
}

// Determine the image height:
$image_height = abs($type_space[5] - $type_space[1]) + 10;

// Determine the initial x- and y- values:
$x = round(($image_width/2) - ((abs($type_space[4] - $type_space[0]))/2));
$y = $image_height - 5;

// Create the image:
$image = imagecreatetruecolor ($image_width, $image_height);

// Allocate the background color and fill the image:
$bg_color = allocate_color ($image, $bg_color);
imagefill ($image, 0, 0, $bg_color);

// Allocate the text color and add the text to the image:
$text_color = allocate_color ($image, $text_color);
imagettftext ($image, $font_size, 0, $x, $y, $text_color, $font_file, $text);

// Save the image on the server:
imagepng ($image, $file_name);

// Destroy the image:
imagedestroy ($image);

// Show the image in the browser:
header ('Content-type: image/png');
readfile($file_name);
?>
