<?php # Script 14.6 - tt_image_web.php

/* 	This page creates a simple image.
 *	The image will contain text of one color
 *	on a background of another color.
 *	The image makes use of a TrueType font.
 *	The image will be based upon $_GET values.
 */

// Include the allocate_color() function:
require_once('allocate_color.php');

// Validate the required information:
if (isset($_GET['text'])) {
	$text = $_GET['text'];
} else {
	$text = 'Your Logo Here!';
}

if (isset($_GET['text_color'])) {
	$text_color = $_GET['text_color'];
} else {
	$text_color = 'black';
}

if (isset($_GET['bg_color'])) {
	$bg_color = $_GET['bg_color'];
} else {
	$bg_color = 'gray';
}

// Define the static image information:
$font_size = 30; // Number in pixels
$font_file = 'arial.ttf'; // Full path to actual font file on server.

// Determine how much space the text will take:
$type_space = imagettfbbox ($font_size, 0, $font_file, $text);

// Determine the image width and height:
$image_width = abs($type_space[4] - $type_space[0]) + 20;
$image_height = abs($type_space[5] - $type_space[1]) + 20;

// Determine the initial x- and y- values:
$x = 10;
$y = $image_height - 10;

// Create the image:
$image = imagecreatetruecolor ($image_width, $image_height);

// Allocate the background color and fill the image:
$bg_color = allocate_color ($image, $bg_color);
imagefill ($image, 0, 0, $bg_color);

// Allocate the text color and add the text to the image:
$text_color = allocate_color ($image, $text_color);
imagettftext ($image, $font_size, 0, $x, $y, $text_color, $font_file, $text);

// Make and send the image:
header ('Content-type: image/png');
imagepng ($image);

// Destroy the image:
imagedestroy ($image);
	
?>
