<?php # Script 4.3 - login.php

/* 	This page uses PEAR Auth to control access.
 *	This assumes a database called "auth",
 *	accessible to a MySQL user of "username@localhost" 
 *	with a password of "password".
 *	Table definition:

	CREATE TABLE auth (
	username VARCHAR(50) default '' NOT NULL,
	password VARCHAR(32) default '' NOT NULL,
	PRIMARY KEY (username),
	KEY (password)
	)
 *	MD5() is used to encrypt the passwords.
 */

// Need the PEAR class:
require_once ('Auth.php');

// Function for showing a login form:
function show_login_form() {

    echo '<form method="post" action="login.php">
<p>Username <input type="text" name="username" /></p>
<p>Password <input type="password" name="password" /></p>
<input type="submit" value="Login" />
</form><br />
';

} // End of show_login_form() function.

// Connect to the database: 
$options = array('dsn' => 'mysql://username:password@localhost/auth');

// Create the Auth object:
$auth = new Auth('DB', $options, 'show_login_form');

// Add a new user:
$auth->addUser('me', 'mypass');

?><!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN"
        "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
<html xmlns="http://www.w3.org/1999/xhtml" xml:lang="en" lang="en">
<head>
	<meta http-equiv="content-type" content="text/html; charset=iso-8859-1" />
	<title>Restricted Page</title>
</head>
<body>
<?php

// Start the authorization:
$auth->start();

// Confirm authorization:
if ($auth->checkAuth()) {

	echo '<p>You are logged in and can read this. How cool is that?</p>';
	
} else { // Unauthorized.
	
	echo '<p>You must be logged in to access this page.</p>';
	
}

?>
</body>
</html>
