<?php # script_01_03.php
// *****************************
// Online Football Picks System

// Developed by: Larry E. Ullman

// Written: August 2001
// Modified: August 14, 2001

// Contact: php@DMCinsights.com

// The process_winners.php page handles the pick_winners.php page. It determines how each player did and stores this information in a text file.

// *****************************
?>
<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN"
        "http://www.w3.org/TR/2000/REC-xhtml1-20000126/DTD/xhtml1-transitional.dtd">
<html xmlns="http://www.w3.org/1999/xhtml">
<head>
	<title>Football Picks</title>
</head>
<body>
<?php

// Set the week as a constant.
define ("WEEK", $week);

/* ---------------------------- */
/* Store the winners in a file. */
/* ---------------------------- */

function write_data ($value, $key, $fp) { // The write_data function stores the picks in the file.

	static $first_line;

	if (!$first_line) { // Write a first dummy line but only once.
		fputs ($fp, "Dummy Line\n");
		$first_line = TRUE;
	}

	fputs ($fp, "$value\n"); // Add a return to place each item on its own line.
}

$file = '2001/picks_' . WEEK . '_Winners_.txt'; // Identify the file in the format 'picks_1_Winners_.txt'.

if ($fp = @fopen ($file, "w")) { // Read the file into an array.

	array_walk ($winners, 'write_data', $fp); // Send the entire array to the write_data function.
	fclose ($fp); // Close the file.

	echo 'The winners have been stored!<br></br>';
	
} else { // If it couldn't open the file, print an error message.
	echo "Could not open the file $file! Please make sure the week variable has a value.<br></br>";
}


/* ---------------------------- */
/* Retrieve the players' picks. */
/* ---------------------------- */

function read_picks ($dp, $directory) { // The read_picks file does just that.

	global $picks;
	
	if ($file_name = readdir ($dp)) { // Check each file in the directory.
	
		if (substr($file_name, 0, 6) == "picks_") { // If it's a picks file continue.
		
			$parse_file_name = explode ("_", $file_name); // Turn the file name into a usable format.
			
			if (($parse_file_name[1] == WEEK) and ($parse_file_name[2] != "Winners")) { // If the file isn't the winners and it's the right week...

				$username = $parse_file_name[2];
				$the_file = $directory . $file_name;
				$users_picks = file ($the_file);
				$picks[$username] = $users_picks;	
			}
		}
		
		read_picks ($dp, $directory); // Loop through the function again.
	} 
}

$picks = array(); // Initialize the main variable.

$directory = '2001/';
$dp = opendir ($directory);
read_picks ($dp, $directory);
closedir ($dp);


/* ----------------------------- */
/* Calculate the week's results. */
/* ----------------------------- */

while (list ($key, $value) = each ($picks)) { // Loop through the main array.

	$wins = 0; // Set to 0 for each array.
	$losses = 0; // Set to 0 for each array.

	while (list ($key2, $value2) = each ($value)) { // Loop through each user's array.
	
		$value2 = substr ($value2, 0, (strlen($value2) - 1)); // Remove the return character.

		if (($value2 == $winners[$key2]) and ($key2 != 0)) { // If the user's pick matches the winning team, give them credit but don't count line 1.
			$wins++;
		} elseif ($key2 != 0 ) {
			$losses++;
		}
	}
	
	$results[$key] = array ('wins' => $wins, 'losses' => $losses); // Store each users performance in an array.
}

ksort ($results); // Aphabetize the array.


/* ------------------------- */
/* Store the week's results. */
/* ------------------------- */

function write_results ($value, $key, $fp) { // Writes results data to a file.

	static $first_line2;

	if (!$first_line2) { // Write a first dummy line but only once.
		fputs ($fp, "User\tWins\tLosses\n"); // Add a return to place each item on its own line.
		$first_line2 = TRUE;
	}

	$data = implode ("\t", $value);
	fputs ($fp, "$key\t$data\n"); // Add a return to place each item on its own line.
}

$file2 = '2001/results_' . WEEK . '_.txt'; // Identify the file in the format 'results_1_.txt'.

if ($fp2 = @fopen ($file2, "w")) { // Open the file for writing.

	array_walk ($results, 'write_results', $fp2); // Send the entire array to the write_results function.
	fclose ($fp2); // Close the file.
	echo 'The results have been stored.<br></br>';
	
} else { // If it couldn't open the file, print an error message.

	echo "Could not open the weekly results file, $file2.<br></br>";
}
?>
</body>
</html>