<?php # Script 10.5
// This page creates a graph based upon data stored in text files.

// This function turns color names into their actual values on the Red-Green-Blue scale.
function color_allocate ($image, $color) {
	switch ($color) {
		case "white":
			$red = 255;
			$green = 255;
			$blue = 255;
			break;	
		case "red":
			$red = 255;
			$green = 51;
			$blue = 51;
			break;	
		case "orange":
			$red = 255;
			$green = 153;
			$blue = 51;
			break;	
		case "yellow":
			$red = 255;
			$green = 255;
			$blue = 51;
			break;	
		case "green":
			$red = 51;
			$green = 255;
			$blue = 51;
			break;	
		case "blue":
			$red = 51;
			$green = 51;
			$blue = 255;
			break;	
		case "purple":
			$red = 255;
			$green = 51;
			$blue = 255;
			break;	
		case "black":
			$red = 0;
			$green = 0;
			$blue = 0;
			break;	
		case "gray":
			$red = 153;
			$green = 153;
			$blue = 153;
			break;	
	}
	return imagecolorallocate ($image, $red, $green, $blue);
}

// Set the font and size info.
$font_size = 10; // Number in pixels
$font_file = "arial.ttf";

if ($HTTP_GET_VARS['week'] == 1) { // Create the image only once.

	define ("WIDTH", 400); // Number of pixels = (17 weeks * 20pixels) + (10pixel spacer * 2) + 40
	define ("HEIGHT", 260); // Number of pixels = 200 pixel scale + (10pixel spacer * 2) + 40

	// Make and send the image.	
	header ("Content-type: image/png");
	$image = @imagecreate (WIDTH, HEIGHT) or die ("A problem occurred trying to create the image.");

} else {
	
	$old_image_name = 'graphs/week_' . ($HTTP_GET_VARS['week'] - 1) . '_graph.png';
	
	// Make and send the image.	
	header ("Content-type: image/png");
	$image = @imagecreatefrompng ($old_image_name) or die ("I couldn't open the original image $old_image_name.");

}

// Set the main colors
$background_color = color_allocate ($image, 'gray');
$text_color = color_allocate ($image, 'black');
$line_color = color_allocate ($image, 'black');
$rectangle_color = color_allocate ($image, 'white');

// Set the user colors
$people_color['Brian'] = color_allocate ($image, 'blue');
$people_color['Juan'] = color_allocate ($image, 'red');
$people_color['Larry'] = color_allocate ($image, 'orange');
$people_color['Michael'] = color_allocate ($image, 'green');

if ($HTTP_GET_VARS['week'] == 1) { // Create the image only once.

	// Create the main image
	imagefill ($image, 0, 0, $background_color); // Not necessary but good form
	imagerectangle ($image, 0, 0, (WIDTH-1), (HEIGHT-1), $line_color); // Border for the image
	imagefilledrectangle ($image, 50, 10, 390, 210, $rectangle_color);
	imagerectangle ($image, 50, 10, 390, 210, $line_color); // Border for the graph
	
	// Make the graph lines
	imagedashedline ($image,50,50,390,50,$line_color);
	imagedashedline ($image,50,90,390,90,$line_color);
	imagedashedline ($image,50,130,390,130,$line_color);
	imagedashedline ($image,50,170,390,170,$line_color);
	
	// Number the graph
	imagettftext ($image, $font_size, 0, 40, 215, $text_color, $font_file, '0');
	imagettftext ($image, $font_size, 0, 35, 175, $text_color, $font_file, '20');
	imagettftext ($image, $font_size, 0, 35, 135, $text_color, $font_file, '40');
	imagettftext ($image, $font_size, 0, 35, 95, $text_color, $font_file, '60');
	imagettftext ($image, $font_size, 0, 35, 55, $text_color, $font_file, '80');
	imagettftext ($image, $font_size, 0, 30, 15, $text_color, $font_file, '100');
	
	for ($i = 1; $i <= 17; $i++) {
		$x = ($i * 20) + 40; // Each week is 20 pixels; 40 pixel offset
		imagettftext ($image, $font_size, 0, $x, 220, $text_color, $font_file, "$i");
	}
	
	imagettftext ($image, ($font_size * 2), 90, 20, 180, $text_color, $font_file, 'Percentage');
	imagettftext ($image, ($font_size * 2), 0, 180, 250, $text_color, $font_file, 'Week');

} // Close the conditional.

// Read the data.
$file_name = 'results_' . $HTTP_GET_VARS['week'] . '_.txt'; 
$x = ($HTTP_GET_VARS[week] * 20) + 42; 

if ($data = @file ("2001/$file_name")) {
	foreach ($data as $key => $value) {
		if ($key != 0) {
			$line = explode ("\t", $value);
			$winning_percentage = round ( ($line[1] / ($line[1] + $line[2]) ) * 100);
			$y = ((100 - $winning_percentage) * 2) + 10;
			
			switch ($line[0]) {
				case "Brian": 
					imagearc ($image, $x, $y, 10, 10, 0, 360, $people_color["$line[0]"]);
					imagefilltoborder ($image, $x, $y, $people_color["$line[0]"], $people_color["$line[0]"]);
					break;
				case "Juan":
					$juans_points[0] = $x; // Diamond top x
					$juans_points[1] = $y - 5; // Diamond top y
					$juans_points[2] = $x + 5;	// Diamond right x
					$juans_points[3] = $y; 	// Diamond right y
					$juans_points[4] = $x; 	// Diamond bottom x
					$juans_points[5] = $y + 5; 	// Dimaond bottom y
					$juans_points[6] = $x - 5; 	// Diamond left x
					$juans_points[7] = $y; 	// Dimaond left y
					imagefilledpolygon ($image, $juans_points, 4, $people_color["$line[0]"]);
					break;
				case "Larry":
					imagefilledrectangle ($image, ($x - 5), ($y - 5), ($x + 5), ($y + 5), $people_color["$line[0]"]);
					break;
				case "Michael":
					$michaels_points[0] = $x; // Diamond top x
					$michaels_points[1] = $y - 5; // Diamond top y
					$michaels_points[2] = $x + 5;	// Diamond right x
					$michaels_points[3] = $y; 	// Diamond right y
					$michaels_points[4] = $x - 5; 	// Diamond left x
					$michaels_points[5] = $y; 	// Dimaond left y
					imagefilledpolygon ($image, $michaels_points, 3, $people_color["$line[0]"]);
					break;
			} // Close the switch
			
			if ($HTTP_GET_VARS['week'] != 1) { // Store this week's results if it's not week 1
				$y_coordinate["$line[0]"] = $y;
			}
		} // Close the $key conditional		
	} // Close the foreach loop
} // Close the WEEK conditional

if ($HTTP_GET_VARS['week'] != 1) { // Connect to last week's marks.
	$old_file_name = 'results_' . ($HTTP_GET_VARS['week'] - 1) . '_.txt'; 
	$old_x = (($HTTP_GET_VARS['week'] - 1) * 20) + 42; 
	
	if ($data = @file ("2001/$old_file_name")) {
		foreach ($data as $key => $value) {
			if ($key != 0) {
				$line = explode ("\t", $value);
				$winning_percentage = round ( ($line[1] / ($line[1] + $line[2]) ) * 100);
				$old_y = ((100 - $winning_percentage) * 2) + 10;
				imageline ($image, $old_x, $old_y, $x, $y_coordinate["$line[0]"], $people_color["$line[0]"]);
			}
		} // Close the $key conditional		
	} // Close the foreach loop
} // Close the WEEK conditional

// Finished!
imagepng ($image);
$new_image_name = 'graphs/week_' . $HTTP_GET_VARS['week'] . '_graph.png';
imagepng ($image, $new_image_name);
imagedestroy ($image); // Destroy the image
?>