<?php # Script 10.2
// This page creates a simple image based upon user-submitted information.

// This function turns color names into their actual values on the Red-Green-Blue scale.
function color_allocate ($image, $color) {
	switch ($color) {
		case "white":
			$red = 255;
			$green = 255;
			$blue = 255;
			break;	
		case "red":
			$red = 255;
			$green = 51;
			$blue = 51;
			break;	
		case "orange":
			$red = 255;
			$green = 153;
			$blue = 51;
			break;	
		case "yellow":
			$red = 255;
			$green = 255;
			$blue = 51;
			break;	
		case "green":
			$red = 51;
			$green = 255;
			$blue = 51;
			break;	
		case "blue":
			$red = 51;
			$green = 51;
			$blue = 255;
			break;	
		case "purple":
			$red = 255;
			$green = 51;
			$blue = 255;
			break;	
		case "black":
			$red = 0;
			$green = 0;
			$blue = 0;
			break;	
	}
	return imagecolorallocate ($image, $red, $green, $blue);
}

if (isset($HTTP_GET_VARS['submit'])) { // Handle the form.

	if ( (isset($HTTP_GET_VARS['background_color'])) AND (isset($HTTP_GET_VARS['text']))  AND (isset($HTTP_GET_VARS['text_color'])) ) {
	
		// Set the font and size info.
		$font_size = 50; // Number from 1-5
		define ("WIDTH", 300); // Number of pixels
		define ("HEIGHT", 100); // Number of pixels

		// Make and send the image.	
		header ("Content-type: image/png");
		$image = @imagecreate (WIDTH, HEIGHT) or die ("A problem occurred trying to create the image.");
		
		$background_color = color_allocate ($image, $HTTP_GET_VARS['background_color']);
		$text_color = color_allocate ($image, $HTTP_GET_VARS['text_color']);

		// Set the True Type Font size
		$type_space = imagettfbbox ($font_size, 0, "arial.ttf", $HTTP_GET_VARS['text']);
		
		while ( ( ( ($type_space[7] - $type_space[1]) + 10 ) >= HEIGHT) OR ( ( ($type_space[2] - $type_space[0]) + 5) >= WIDTH) ) {
			$font_size--;
			$type_space  = imagettfbbox ($font_size, 0, "arial.ttf", $HTTP_GET_VARS['text']);
		}

		$x = round ( (WIDTH -  ($type_space[2] - $type_space[0])) / 2);
		$y = round ( (HEIGHT - ($type_space[7] - $type_space[1])) / 2);
		imagefill ($image, 0, 0, $background_color); // Not necessary but good form
		imagettftext ($image, $font_size, 0, $x, $y, $text_color, "arial.ttf", $HTTP_GET_VARS['text']);
		
		imagepng ($image);
		imagedestroy ($image); // Destroy the image
	
	} else {
		echo "You either forgot to select a background color, a text color or your forgot to enter the text itself.\n";
	}

} else {
	// Display the form
?>
<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN"
        "http://www.w3.org/TR/2000/REC-xhtml1-20000126/DTD/xhtml1-transitional.dtd">
<html xmlns="http://www.w3.org/1999/xhtml">
<head>
	<title>Create An Image</title>
</head>
<body>
<form action="image_tt_form.php" method="get">
<table border="0" width="80%" cellspacing="2" cellpadding="2" align="center">
	<tr align="center" valign="top">
		<td align="center" valign="top" colspan="2">Fill out the form to have your image created!</td>
	</tr>
	<tr align="center" valign="top">
		<td align="right" valign="top">Enter the image text:</td>
		<td align="left" valign="top"><input type="text" name="text" size="20" maxlength="40"></td>
	</tr>
	<tr align="center" valign="top">
		<td align="right" valign="top">Select the text color:</td>
		<td align="left" valign="top"><select name="text_color">
<option value="white">White</option>
<option value="red">Red</option>
<option value="orange">Orange</option>
<option value="yellow">Yellow</option>
<option value="green">Green</option>
<option value="blue">Blue</option>
<option value="purple">Purple</option>
<option value="black">Black</option>
</select></td>
	</tr>
	<tr align="center" valign="top">
		<td align="right" valign="top">Select the background color:</td>
		<td align="left" valign="top"><select name="background_color">
<option value="white">White</option>
<option value="red">Red</option>
<option value="orange">Orange</option>
<option value="yellow">Yellow</option>
<option value="green">Green</option>
<option value="blue">Blue</option>
<option value="purple">Purple</option>
<option value="black">Black</option>
</select></td>
	</tr>
	<tr align="center" valign="top">
		<td align="center" valign="top" colspan="2"><input type="submit" name="submit" value="Make The Image!"></td>
	</tr>
</table>
</form>
</body>
</html>
<?php
} // Close the SUBMIT conditional.
?>
