<?php # Script 11.3
// This page creates an invoice based upon user-submitted information.

if (isset($HTTP_POST_VARS['submit'])) { // Handle the form.

	if ( (isset($HTTP_POST_VARS['client'])) AND (isset($HTTP_POST_VARS['amount']))  AND (isset($HTTP_POST_VARS['invoice_number'])) ) {
	
		// Set the constants and variables.
		define ("PAGE_WIDTH", 612); // 8.5 inches
		define ("PAGE_HEIGHT", 792); // 11 inches
		define ("FONT_SIZE", 18); // Large 0.5 inch type
		define ("INCH", 72);

		// Make the invoice.	
		$pdf = pdf_new();
		pdf_open_file ($pdf, "");
		
		// Set the different PDF values.
		pdf_set_info ($pdf, "Author", "Larry E. Ullman");
		pdf_set_info ($pdf, "Title", "Invoice for " . $HTTP_POST_VARS['client']);
		pdf_set_info ($pdf, "Creator", "See Author");

		// Create the page.
		pdf_begin_page ($pdf, PAGE_WIDTH, PAGE_HEIGHT);

		// Make a smiley face watermark.
		pdf_setlinewidth ($pdf, 3);
		pdf_setcolor ($pdf, 'both', 'rgb', 0.8, 0.8, 0.8, 0);
		pdf_circle ($pdf, (PAGE_WIDTH/2), (PAGE_HEIGHT/2), ( (PAGE_WIDTH - INCH - INCH)/2) );
		pdf_stroke ($pdf);
		pdf_circle ($pdf, (round (PAGE_WIDTH/3) * 1), (PAGE_HEIGHT - (PAGE_HEIGHT/3)), 18);
		pdf_stroke ($pdf);
		pdf_circle ($pdf,  (round (PAGE_WIDTH/3) * 2), (PAGE_HEIGHT - (PAGE_HEIGHT/3)), 18);
		pdf_stroke ($pdf);
		pdf_arc ($pdf, (PAGE_WIDTH/2), (PAGE_HEIGHT/2), 144, 210, 330);
		pdf_stroke ($pdf);
		pdf_setlinewidth ($pdf,1);

		// Print a title.
		$helvetica_bold = pdf_findfont ($pdf, "Helvetica-Bold", "winansi");
		pdf_setfont ($pdf, $helvetica_bold, 36);
		pdf_set_value ($pdf, "textrendering", 2);
		pdf_setcolor ($pdf, 'both', 'rgb', 0.2, 0.2, 1.0, 0);
		$width = pdf_stringwidth ($pdf, 'DMC Insights, Inc.');
		$x = round ((PAGE_WIDTH - $width) / 2);
		pdf_show_xy ($pdf, 'DMC Insights, Inc.', $x, (PAGE_HEIGHT - INCH)); 
		pdf_setcolor ($pdf, 'both', 'rgb', 0, 0, 0, 0);

		// Print the subtitle.
		$helvetica_obl = pdf_findfont ($pdf, "Helvetica-Oblique", "winansi");
		pdf_setfont ($pdf, $helvetica_obl, 24);
		pdf_set_value ($pdf, "textrendering", 0);
		$width = pdf_stringwidth ($pdf, 'Invoice For Services Completed');
		$x = round ((PAGE_WIDTH - $width) / 2);
		pdf_show_xy ($pdf, 'Invoice For Services Completed', $x, (PAGE_HEIGHT - INCH - 36 - 18)); 
		
		// Set the default font from here on out.
		$times = pdf_findfont ($pdf, "Times-Roman", "winansi");
		pdf_setfont ($pdf, $times, FONT_SIZE);
		
		// Print the remaining lines.
		pdf_set_parameter ($pdf, "underline", "true");
		pdf_show_xy ($pdf, 'Invoice Date:', INCH, (PAGE_HEIGHT - (INCH * 3)) ); 
		pdf_set_parameter ($pdf, "underline", "false");
		pdf_show ($pdf, ' ' . date("F j, Y")); 
		$used_height = (INCH * 3) + FONT_SIZE;

		pdf_set_value ($pdf, "leading", (FONT_SIZE * 2) );
		pdf_set_parameter ($pdf, "underline", "true");
		pdf_continue_text ($pdf, 'Invoice Number:'); 
		pdf_set_parameter ($pdf, "underline", "false");
		pdf_show ($pdf, ' ' . $HTTP_POST_VARS['invoice_number']); 
		$used_height += (FONT_SIZE * 3);

		pdf_set_value ($pdf, "leading", (FONT_SIZE * 2) );
		pdf_set_parameter ($pdf, "underline", "true");
		pdf_continue_text ($pdf, 'Client:'); 
		pdf_set_parameter ($pdf, "underline", "false");
		pdf_show ($pdf, ' ' . $HTTP_POST_VARS['client']); 
		$used_height += (FONT_SIZE * 3);

		pdf_set_value ($pdf, "leading", (FONT_SIZE * 2) );
		pdf_set_parameter ($pdf, "underline", "true");
		pdf_continue_text ($pdf, 'Amount Due:'); 
		pdf_set_parameter ($pdf, "underline", "false");
		pdf_show ($pdf, ' $' . $HTTP_POST_VARS['amount']); 
		$used_height += (FONT_SIZE * 3);

		pdf_set_value ($pdf, "leading", (FONT_SIZE * 2) );
		pdf_set_parameter ($pdf, "underline", "true");
		pdf_continue_text ($pdf, "Description of Work:"); 
		pdf_set_parameter ($pdf, "underline", "false");

		// Determine the description of work box size.		
		$box_height = FONT_SIZE;
		while ((pdf_show_boxed  ($pdf, $HTTP_POST_VARS['description'], INCH, (PAGE_HEIGHT - $used_height - $box_height), (PAGE_WIDTH - (INCH * 2)), $box_height, "justify", "blind")) > 0 ) {
			$box_height += FONT_SIZE;
		} 
		
		// Make sure there's enough room.
		$remaining_space = PAGE_HEIGHT - ($used_height + INCH);
		
		$font_size = FONT_SIZE;
		while ( $box_height > $remaining_space ) {
			$font_size = $font_size - 2;
			pdf_setfont ($pdf, $times, $font_size);
			
			$box_height = $font_size;
			while ((pdf_show_boxed  ($pdf, $HTTP_POST_VARS['description'], INCH, (PAGE_HEIGHT - $used_height - $box_height), (PAGE_WIDTH - (INCH * 2)), $box_height, "justify", "blind")) > 0 ) {
				$box_height += $font_size;
			} 
		} 
		pdf_show_boxed ($pdf, $HTTP_POST_VARS['description'], INCH, (PAGE_HEIGHT - $used_height - $box_height), (PAGE_WIDTH - (INCH * 2)), $box_height, 'justify'); 

		// Outline the page.
		pdf_setlinewidth ($pdf, 6);
		pdf_setlinejoin ($pdf, 1);
		pdf_rect ($pdf, (INCH/2), (INCH/2), (PAGE_WIDTH - INCH), (PAGE_HEIGHT - INCH));
		pdf_stroke ($pdf);

		// Underline the subtitle.
		pdf_setcolor ($pdf, 'both', 'rgb', 1.0, 0.6, 0.2, 0);
		pdf_setlinewidth ($pdf, 12);
		pdf_setlinecap ($pdf, 1);
		pdf_setdash ($pdf, 20, 15);
		pdf_moveto ($pdf, INCH, (PAGE_HEIGHT - INCH - 36 - 36));
		pdf_lineto ($pdf, (PAGE_WIDTH - INCH), (PAGE_HEIGHT - INCH - 36 - 36));
		pdf_stroke ($pdf);
		
		// Finish the page.
		pdf_end_page($pdf);
		
		// Close the PDF.
		pdf_close($pdf);
		
		// Send the PDF to the browser.
		$buffer = pdf_get_buffer ($pdf);
		header ("Content-type: application/pdf");
		header ("Content-Length: " . strlen($buffer));
		header ("Content-Disposition: inline; filename=" . $HTTP_POST_VARS['invoice_number'] . ".pdf");
		echo $buffer;

		// Free the resources.
		pdf_delete ($pdf);
	
	} else {
		echo "You either forgot to enter the client's name, the invoice number, or the amount due. Please go back and try again.\n";
	}

} else {
	// Display the form.
?>
<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN"
        "http://www.w3.org/TR/2000/REC-xhtml1-20000126/DTD/xhtml1-transitional.dtd">
<html xmlns="http://www.w3.org/1999/xhtml">
<head>
	<title>Create An Invoice</title>
</head>
<body>
<form action="create_pdf_invoice2.php" method="POST">
<table border="0" width="80%" cellspacing="2" cellpadding="2" align="center">
	<tr align="center" valign="top">
		<td align="center" valign="top" colspan="2">Fill out the form to have your invoice created!</td>
	</tr>
	<tr align="center" valign="top">
		<td align="right" valign="top">Enter the client's name:</td>
		<td align="left" valign="top"><input type="text" name="client" size="40" maxlength="80"></td>
	</tr>
	<tr align="center" valign="top">
		<td align="right" valign="top">Enter the invoice number:</td>
		<td align="left" valign="top"><input type="text" name="invoice_number" size="10" maxlength="20"></td>
	</tr>
	<tr align="center" valign="top">
		<td align="right" valign="top">Enter the amount due (without the dollar sign):</td>
		<td align="left" valign="top"><input type="text" name="amount" size="10" maxlength="10"></td>
	</tr>
	<tr align="center" valign="top">
		<td align="right" valign="top">Enter a description of the work:</td>
		<td align="left" valign="top"><textarea name="description" rows="5" cols="40"></textarea></td>
	</tr>
	<tr align="center" valign="top">
		<td align="center" valign="top" colspan="2"><input type="submit" name="submit" value="Make The Invoice!"></td>
	</tr>
</table>
</form>
</body>
</html>
<?php
} // Close the SUBMIT conditional. 
?>