<?php # Script 12.2

// This script uses GTK to create a calculator.

// Include the GTK module.
if (!extension_loaded('gtk')) {
	if (strtoupper(substr(PHP_OS, 0, 3)) == 'WIN') {
		dl('php_gtk.dll');
	} else {
		dl('php_gtk.so');
	}
}

// This function is for when the window is closed.
function quit () {
	gtk::main_quit();
}

// The calculate() function does the actual math.
function calculate () {
	global $a;
	global $b;
	global $operator;
	
	switch ($operator) {
		case 'add':
			$value = $a + $b;
			break;
		case 'subtract':
			$value = $a - $b;
			break;
		case 'multiply':
			$value = $a * $b;
			break;
		case 'divide':
			$value = $a / $b;
			break;
	}
	set_window ($value); // Display the calculated value.	
}

// Function for assigning the operator being used.
function operator ($thing, $which) {
	global $operator;
	$operator = $which;
}

// Function for resetting the calculator.
function clear () {
	global $a;
	global $b;
	global $operator;
	
	$a = FALSE;
	$b = FALSE;
	$operator = 'na';
	
	set_window (0);		
}

// Function for assigning values.
function assign ($thing, $number) {
	global $a;
	global $b;
	global $operator;
	global $display;
		
	if ($operator == 'na') {
		$a .= $number;
		$display->set_textwindow($a); // Display the value.
	} else {
		$b .= $number;
		$display->set_textwindow($b); // Display the value.
	}
}

// Function for displaying value in the calculator 'window'.
function set_window ($value) {
	global $display;
	$display->set_text ($value);
}


// *******************
// ******************* End of Functions
// *******************

// Create a new window.
$window = &new GtkWindow();
$window->set_title ('Calculator');
$window->set_default_size (320, 320);

// Create another container.
$box = &new GtkVBox();
$window->add($box);
$box->show();

// Make a table.
$table = &new GtkTable(5, 6);
$table->set_row_spacings(2);
$table->set_col_spacings(2);
$table->set_border_width(5);
$box->pack_start($table);
$table->show();

// Make the 0-9 buttons.
for ($i = 0; $i <= 9; $i++) {
	
	switch ($i) {
		case "0":
			$x = 1;
			$y = 5;
			break;
		case "1":
			$x = 1;
			$y = 4;
			break;
		case "2":
			$x = 2;
			$y = 4;
			break;
		case "3":
			$x = 3;
			$y = 4;
			break;
		case "4":
			$x = 1;
			$y = 3;
			break;
		case "5":
			$x = 2;
			$y = 3;
			break;
		case "6":
			$x = 3;
			$y = 3;
			break;
		case "7":
			$x = 1;
			$y = 2;
			break;
		case "8":
			$x = 2;
			$y = 2;
			break;
		case "9":
			$x = 3;
			$y = 2;
			break;
	}
	$button = &new gtkbutton($i);
	$button->connect ('clicked', 'assign', $i);
	$table->attach($button, $x, ($x+1), $y, ($y+1));
}

// Place the remaining buttons.
$decimal = &new gtkbutton('.');
$decimal->connect ('clicked', 'assign', '.');
$table->attach($decimal, 2, 3, 5, 6);

$equals = &new gtkbutton('=');
$equals->connect ('clicked', 'calculate', $i);
$table->attach($equals, 3, 4, 5, 6);

$display = &new gtklabel('display');
$display->set_text ('0');
$table->attach($display, 1, 4, 1, 2);

$clear = &new gtkbutton('C');
$clear->connect ('clicked', 'clear');
$table->attach($clear, 4, 5, 1, 2);

$add = &new gtkbutton('+');
$add->connect ('clicked', 'operator', 'add');
$table->attach($add, 4, 5, 2, 3);

$subtract = &new gtkbutton('-');
$subtract->connect ('clicked', 'operator', 'subtract');
$table->attach($subtract, 4, 5, 3, 4);

$multiply = &new gtkbutton('*');
$multiply->connect ('clicked', 'operator', 'multiply');
$table->attach($multiply, 4, 5, 4, 5);

$divide = &new gtkbutton('/');
$divide->connect ('clicked', 'operator', 'divide');
$table->attach($divide, 4, 5, 5, 6);

$display = &new gtklabel('display');
$display->set_text ('0');
$table->attach($display, 1, 4, 1, 2);

// Reset the calculator.
clear();

// Connect the quit function and finish the script.
$window->connect('delete_event', 'quit');
$window->show_all();

gtk::main();
?>