<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN"
        "http://www.w3.org/TR/2000/REC-xhtml1-20000126/DTD/xhtml1-transitional.dtd">
<html xmlns="http://www.w3.org/1999/xhtml">
<head>
	<title>Database Query Script</title>
</head>
<body>
<?php # Script 12.1
// This page displays and HTML form and handles it. The purpose is to directly query a database via the Web browser.

if (isset($HTTP_POST_VARS['submit'])) { // If the form has been submitted, process it.

	// Set the database parameters.
	$db_password = 'password';
	$db_username = 'username';
	$db_database = 'database';
	$db_host = 'localhost';
	$db_type = 'mysql';

	// Require the PEAR database and timing classes.
	require_once ('DB.php');
	require_once ('Benchmark/Timer.php');

	// Start the timer.
	$timer = new Benchmark_Timer;
	$timer->start();

	// Establish a connection.
	$db = DB::connect ("$db_type://$db_username:$db_password@$db_host/$db_database");

	// If the connection worked, continue.	
	if (DB::isError($db)) {
	
		die (DB::errorMessage($db));
		
	} else { // OK to query the database.
	
		$result = $db->query($query);
		if (DB::isError($result)) {
			die(DB::errorMessage($result));
		} else {
			echo '<table align="center" cellpadding="2" cellspacing="2" border="0">';
			while ($row = $result->fetchRow()) {
				echo '<tr>';
				foreach ($row as $key => $value) {
					echo "<td>$value</td>";
				}
				echo '</tr>';
			}
			echo '</table><br /><hr />';
		} 
		
		// Close the connection.
		$db->disconnect();
		
	}
	
	// Stop the timer and print the result.
	$timer->stop();
	$timer_result = $timer->getProfiling();
	echo "The PHP execution took {$timer_result[1]['total']} seconds.<br />";
	
} // Close the submit conditional.

// Display the form.
?>
This page allows you to query a database. Enter your query--in proper SQL form--in the text box below, then click Submit.<br />
<form action="db_query.php" method="post">
<textarea name="query" rows="5" cols="40"></textarea><br />
<input type="submit" name="submit" value="Submit" />
</form>
</body>
</html>
