<?php # Script 2.15
// This is a page that uses object serialization.

require_once "HtmlTemplate2.class"; // Include the class.
require_once "HtmlNavTemplate.class"; // Include the class.

if ($HTTP_COOKIE_VARS['html_object']) {

	$page = unserialize ($HTTP_COOKIE_VARS['html_object']);    

	$page->CreatePage();

} elseif ($HTTP_POST_VARS['submit']) {

	$page = new HtmlNavTemplate ("template4.inc"); // Create an instance and identify the template to use for this application.

	$page->SetParameter ("PAGE_TITLE", $page_title); // Set the page title.
	$page->SetParameter ("CSS_LINK", "style.css"); // Set the style sheet.
	$page->SetParameter ("BG_COLOR", $bg_color); // Set the background color.
	$page->SetParameter ("TEXT_COLOR", $text_color); // Set the text color.
	$page->SetParameter ("TABLE_WIDTH", $table_width); // Set the table width.
	$page->SetParameter ("NAVIGATION_LINKS", $page->DetermineLinks());
	$page->SetParameter ("PAGE_CONTENT", "Here is your custom page."); // Set the main content.
	
	setcookie ("html_object", serialize ($page), time() + 100000, "", "", 0);
	
	$page->CreatePage();

} else {

	$page = new HtmlNavTemplate ("template4.inc"); // Create an instance and identify the template to use for this application.

	$page->SetParameter ("PAGE_TITLE", "Set Your Preferences!"); // Set the page title.
	$page->SetParameter ("CSS_LINK", "style.css"); // Set the style sheet.
	$page->SetParameter ("BG_COLOR", "WHITE"); // Set the background color.
	$page->SetParameter ("TEXT_COLOR", "BLACK"); // Set the text color.
	$page->SetParameter ("TABLE_WIDTH", "100"); // Set the table width.
	$page->SetParameter ("NAVIGATION_LINKS", $page->DetermineLinks());

	$content = '<form action="instance5.php" method=post>
	<table border=0 width="90%" cellspacing="2" cellpadding="2" align="center">
		<tr align="center" valign="top">
			<td colspan="2" align="center" valign="top">Set Your HTML Layout Preferences</td>
		</tr>
		<tr align="center" valign="top">
			<td width="50%" align="right" valign="top">Page Title:</td>
			<td width="50%" align="left" valign="top"><input type="text" name="page_title" size="20" maxsize="50"></td>
		</tr>
		<tr align="center" valign="top">
			<td width="50%" align="right" valign="top">Background Color:</td>
			<td width="50%" align="left" valign="top">
				<select name="bg_color">
				<option value="white">WHITE</option>
				<option value="black">BLACK</option>
				<option value="blue">BLUE</option>
				<option value="red">RED</option>
				<option value="green">GREEN</option>
				</select></td>
		</tr>
		<tr align="center" valign="top">
			<td width="50%" align="right" valign="top">Text Color:</td>
			<td width="50%" align="left" valign="top">
				<select name="text_color">
				<option value="white">WHITE</option>
				<option value="black">BLACK</option>
				<option value="blue">BLUE</option>
				<option value="red">RED</option>
				<option value="green">GREEN</option>
				</select></td>
		</tr>
		<tr align="center" valign="top">
			<td width="50%" align="right" valign="top">Table Width (0-100):</td>
			<td width="50%" align="left" valign="top"><input type="text" name="table_width" size="3" maxsize="3"></td>
		</tr>
		<tr align="center" valign="top">
			<td colspan="2" align="center" valign="top"><input type="submit" name="submit" value="Set My Preferences"></td>
		</tr>
	</table>
	</form>';

	$page->SetParameter ("PAGE_CONTENT", $content); // Set the main content.

	$page->CreatePage(); // Send the page to the browser.
}
unset ($page);
?>