<?php # Script 6.13

// This is a basic home page for the administration side of the site.

require_once ("../config.inc"); // Include the Configuration file.
require_once ("classes/ShoppingCart.class"); // Include the class.
session_start(); // Start the session.

$page_title = 'Your Shopping Cart';
require_once ("includes/public_header.inc"); // Include the HTML formatting.

// ***************************************************************
// Page specific content begins here
// ***************************************************************

if (isset ($HTTP_SESSION_VARS['cart'])) { // If there's already a session/object...
	$cart = $HTTP_SESSION_VARS['cart'];
} else {
	$cart = new ShoppingCart();
}

switch ($HTTP_GET_VARS['do']) {

	case "Add":
		$cart->AddItem ($HTTP_GET_VARS[pid]);
		$cart->DisplayCart();
		break;
		
	case "Drop":
		$cart->DropItem ($HTTP_GET_VARS[pid]);
		$cart->DisplayCart();
		break;
		
	case "Change":
		foreach ($HTTP_POST_VARS[pid] as $key => $value) {
			$cart->ChangeQuantity ($key, $value);
		}
		$cart->DisplayCart();
		break;
		
	case "Display":
		$cart->DisplayCart();
		break;
		
	default:
		$cart->DisplayCart();
		break; // Same as display.

}

session_register ('cart');

// ***************************************************************
// End of page specific content	
// ***************************************************************

require_once ("includes/public_footer.inc"); // Finish the HTML formatting.
?>