# Create the database.
CREATE DATABASE larrys_books;

USE larrys_books;

# Make the books table.
CREATE TABLE books (
book_id INT UNSIGNED NOT NULL AUTO_INCREMENT,
title VARCHAR(100),
author_id INT UNSIGNED,
format_id INT UNSIGNED,
call_number VARCHAR(40),
notes TEXT,
date_entered DATE,
signed ENUM ('Y', 'N') DEFAULT 'N',
PRIMARY KEY (book_id),
INDEX (title)
);

# Make the authors table.
CREATE TABKE authors (
author_id INT UNSIGNED NOT NULL AUTO_INCREMENT,
last_name VARCHAR(50),
first_name VARCHAR(30),
PRIMARY KEY (author_id),
INDEX (last_name)
);

# Make the formats table.
CREATE TABLE formats (
format_id INT UNSIGNED NOT NULL AUTO_INCREMENT,
format VARCHAR(15),
PRIMARY KEY (format_id),
INDEX (format)
);

# Add data to the format table.
INSERT INTO formats VALUES
(NULL, 'Hardcover'),
(NULL, 'Trade Paperback'),
(NULL, 'Mass Market')
;