# Make the community database.
CREATE DATABASE community;

USE community;

# Make the users table.
CREATE TABLE users (
user_id INT UNSIGNED NOT NULL AUTO_INCREMENT,
username VARCHAR(16) NOT NULL,
password VARCHAR(13) NOT NULL,
first_name VARCHAR(20),
last_name VARCHAR(40),
email VARCHAR(60),
birthday DATE,
PRIMARY KEY (user_id),
INDEX (username),
UNIQUE (username)
);

# Make the events table.
CREATE TABLE events (
event_id INT UNSIGNED NOT NULL AUTO_INCREMENT,
event_date DATE NOT NULL,
start_time TIME NOT NULL,
end_time TIME NOT NULL,
description VARCHAR(255),
title VARCHAR(60) NOT NULL,
submitted_by INT UNSIGNED NOT NULL,
PRIMARY KEY (event_id),
INDEX (event_date)
);

# Make the groups table.
CREATE TABLE groups (
group_id INT UNSIGNED NOT NULL AUTO_INCREMENT,
group_name VARCHAR(20) NOT NULL,
administrator_id INT UNSIGNED NOT NULL,
PRIMARY KEY (group_id),
INDEX (group_name)
);

# Update the users table to reflect the groups.
ALTER TABLE users ADD COLUMN group_id INT UNSIGNED NOT NULL;