# Make the waponi_woo database.
CREATE DATABASE waponi_woo;

USE waponi_woo;

# Make the users table.
CREATE TABLE users (
user_id INT UNSIGNED NOT NULL AUTO_INCREMENT,
username VARCHAR(16) NOT NULL,
password VARCHAR(13) NOT NULL,
first_name VARCHAR(20),
last_name VARCHAR(40),
email VARCHAR(60),
address1 VARCHAR(80),
address2 VARCHAR(80),
city VARCHAR(40),
state VARCHAR(2),
zip VARCHAR(10),
phone VARCHAR(20),
PRIMARY KEY (user_id),
INDEX (username),
UNIQUE (username)
);

# Make the products table.
CREATE TABLE products (
product_id INT UNSIGNED NOT NULL AUTO_INCREMENT,
name_id INT UNSIGNED NOT NULL,
size_id INT UNSIGNED NOT NULL,
format_id INT UNSIGNED NOT NULL,
price DECIMAL(8,2),
available ENUM('Yes', 'No'),
picture VARCHAR(30),
PRIMARY KEY (product_id)
);

# Make the product_names table.
CREATE TABLE product_names (
product_name_id INT UNSIGNED NOT NULL AUTO_INCREMENT,
product_name VARCHAR(25),
PRIMARY KEY (product_name_id)
);

# Make the product_sizes table.
CREATE TABLE product_sizes (
product_size_id INT UNSIGNED NOT NULL AUTO_INCREMENT,
product_size VARCHAR(25),
PRIMARY KEY (product_size_id)
);

# Make the product_formats table.
CREATE TABLE product_formats (
product_format_id INT UNSIGNED NOT NULL AUTO_INCREMENT,
product_format VARCHAR(25),
PRIMARY KEY (product_format_id)
);

# Make the orders table.
CREATE TABLE orders (
order_id INT UNSIGNED NOT NULL AUTO_INCREMENT,
user_id INT UNSIGNED NOT NULL,
total DECIMAL (10,2),
credit_card_number INT UNSIGNED,
date_ordered DATETIME,
shopping_cart TEXT,
PRIMARY KEY (order_id)
);