<?php // Script 8.10 - register.php (second version after Script 8.9)
// This page lets people register for the site (sort of).

// Address error handing.
ini_set ('display_errors', 1);
error_reporting (E_ALL & ~E_NOTICE);

// Set the page title and include the header file.
define ('TITLE', 'Register');
require ('templates/header.html');

// Basic HTML formatting stuff.
print '<div id="leftcontent">
	<h1>Registration Form</h1>
	<p>Register so that you can take advantage of certain features like this, that, and the other thing.</p>';

// Check if the form has been submitted.
if ( isset ($_POST['submit'])) {

	$problem = FALSE; // No problems so far.
	
	// Check for each value.
	if (empty ($_POST['username'])) {
		$problem = TRUE;
		print '<p>Please enter a username!</p>';
	}
	
	if (empty ($_POST['first_name'])) {
		$problem = TRUE;
		print '<p>Please enter your first name!</p>';
	}
	
	if (empty ($_POST['last_name'])) {
		$problem = TRUE;
		print '<p>Please enter your last name!</p>';
	}
	
	if (empty ($_POST['email'])) {
		$problem = TRUE;
		print '<p>Please enter your email address!</p>';
	}

	if (empty ($_POST['password1'])) {
		$problem = TRUE;
		print '<p>Please enter a password!</p>';
	}
	
	if ($_POST['password1'] != $_POST['password2']) {
		$problem = TRUE;
		print '<p>Your password did not match your confirmed password!</p>';
	} 
	
	if (!$problem) { // If there weren't any problems...
	
		print '<p>You are now registered!<br />Okay, you are not really registered but...</p>';
		
		// Send the email.
		$body = "Thank you for registering with the Elliott Smith fan club!
Your username is {$_POST['username']}. Your password is {$_POST['password1']}.";
		mail ($_POST['email'], 'Thank you for registering at the Elliott Smith Fan Club!', $body, 'From: admin@site.com');
	
	} else { // Forgot a field.
	
		print '<p>Please try again!</p>';
		
	}

} // End of handle form IF.

// Display the form.
print '<form action="register.php" method="post"><p>';

print 'Username: <input type="text" name="username" size="20" value="' . $_POST['username'] . '" /><br />';

print 'First Name: <input type="text" name="first_name" size="20" value="' . $_POST['first_name'] . '" /><br />
Last Name: <input type="text" name="last_name" size="20" value="' . $_POST['last_name'] . '" /><br />
Email Address: <input type="text" name="email" size="20" value="' . $_POST['email'] . '" /><br />';

print 'Password: <input type="password" name="password1" size="20" /><br />
Confirm Password: <input type="password" name="password2" size="20" /><br />
<input type="submit" name="submit" value="Register!" /></p>
</form>';

// Complete the HTML formatting stuff.
print '</div>';

require ('templates/footer.html'); // Need the footer.
?>