<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN"
        "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
<html xmlns="http://www.w3.org/1999/xhtml">
<head>
	<meta http-equiv="content-type" content="text/html; charset=iso-8859-1" />
	<title>Directory Contents</title>
</head>
<body>
<?php // Script 11.5 - list_dir.php
// This script lists the directories and files in a directory.

// Address error handing.
ini_set ('display_errors', 1);
error_reporting (E_ALL & ~E_NOTICE);

// Set the directory name and open it.
$search_dir = '.';
$dp = opendir ($search_dir);

// List the directories first.
while ($item = readdir ($dp) ) {
	if ( (is_dir ($item)) AND (substr ($item, 0, 1) != '.') ) {
		print "$item<br />\n";
	}
}

rewinddir ($dp); // Reset the pointer.

// Create a table header.
print '<hr /><br />
<table cellpadding="2" cellspacing="2" align="left">
<tr>
<td><b>File Name</b></td>
<td><b>File Size</b></td>
<td><b>Last Modified</b></td>
</tr>';

// List the files.
while ($item = readdir ($dp) ) {
	if ( (is_file ($item)) AND (substr ($item, 0, 1) != '.') ) {
	
		// Get the file size.
		$fs = filesize ($item);
		
		// Get the file's modification date.
		$lm = date ('F j, Y', filemtime ($item));
		
		// Print the information.
		print "<tr>
		<td>$item</td>
		<td>$fs bytes</td>
		<td>$lm</td>
	</tr>\n";
	
	} // Close the IF.

} // Close the WHILE.

print '</table>'; // Close the HTML table.

closedir ($dp); // Close the directory.

?>
</body>
</html>
